/*

Copyright (c) 2004 PXI Project Team

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in the
Software without restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies
or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "bchasm.h"
#include <cstdio>
#include <cstring>
using namespace std;

extern PXIAbstractFramework myAbstractFramework;

variant::variant( const variant &v )
{
	if ( v.reference )
	{
		reference = true;
		me = v.me;
	}
	else
	{
		if ( v.vtype )
		{
			vtype = true;
			longValue = v.longValue;
		}
		else
		{
			vtype = false;
			stringValue = v.stringValue;
		}
		if ( ! v.myDataMembers.empty() )
		{
			myDataMembers = v.myDataMembers;
		}
		chunkValue = NULL;
		dirty = false;
		reference = false;
		me = this;
	}
	vchunk = v.vchunk;
	chunkStart = v.chunkStart;
	chunkStop = v.chunkStop;
	chunkType = v.chunkType;
}

variant::variant( const double &l )
{
    vtype = true;
    longValue = l;
	chunkValue = NULL;
	vchunk = false;
	chunkStart = 0;
	chunkStop = -1;
	dirty = false;
	reference = false;
	me = this;
}

variant::variant( const string &s )
{
    vtype = false;
    stringValue = s;
	chunkValue = NULL;
	vchunk = false;
	chunkStart = 0;
	chunkStop = -1;	
	dirty = false;
	reference = false;
	me = this;
}

const variant &variant::Copy( const variant &v )
{
	if ( v.reference )
	{
		reference = true;
		me = v.me;
	}
	else
	{
		if ( v.vtype )
		{
			vtype = true;
			longValue = v.longValue;
		}
		else
		{
			vtype = false;
			stringValue = v.stringValue;
		}
		if	( ! v.myDataMembers.empty() )
		{
			myDataMembers = v.myDataMembers;
		}
		dirty = true;
	}
	
	vchunk = v.vchunk;
	chunkStart = v.chunkStart;
	chunkStop = v.chunkStop;
	chunkType = v.chunkType;
	
	return *this;
}

const variant &variant::Copy( const string &s )
{

	vtype = false;
	stringValue = s;
	dirty = true;
    return *this;
}

const variant &variant::Copy( const double &l )
{
	vtype = true;
	longValue = l;
	dirty = true;
	return *this;
}


const double variant::intVal( void )
{
	if ( vchunk )
	{
		// No point in even doing the conversion.
		return val ( cxl_get_chunk( strVal(), chunkType, chunkStart, chunkStop ) ); 
	}
	if ( reference )
	{
		if ( vchunk )
		{
			
		}
		else
		{
			return (*me).intVal();
		}
	}
	else
	{
		char **a = NULL;
		if ( vtype )
		{
			return longValue;
		}
		else
		{
			vtype = true;
			longValue = strtod( stringValue.c_str(), a );
			return longValue;
		}
	}
}

const string variant::strVal( void )
{
	if ( reference )
	{
		if ( vchunk )
		{
			return cxl_get_chunk( (*me).strVal(), chunkType, chunkStart, chunkStop ); 
		}
		else
		{
			return (*me).strVal();
		}
	}
	else
	{
		char a[ 255 ] = {0};
		if ( vtype )
		{
			vtype = false;
			snprintf( a, 254, "%g", longValue );
			stringValue = a;
		}
		if ( vchunk )
		{
			return cxl_get_chunk( stringValue, chunkType, chunkStart, chunkStop ); 
		}
		else
		{
			return stringValue;
		}
	}
}

variant::~variant( void )
{
	if( chunkValue )
	{
		delete chunkValue;
	}
}
